using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Trkanje
{
    class Program
    {
        struct Tacka
        {
           public double x, y;
        }
        struct Trkac
        {
            public double x0, y0;
            public char smer;
        }
        struct Dogadjaj
        {
            public double x, y, t;
        }
        static bool Susret(Trkac t1, Trkac t2)
        {
            if (t1.smer == t2.smer) return false;
            if ((t1.smer == 'N' && t2.smer == 'S') || (t1.smer == 'S' && t2.smer == 'N'))
                return t1.y0 == t2.y0;
            if ((t1.smer == 'W' && t2.smer == 'E') || (t1.smer == 'E' && t2.smer == 'W'))
                return t1.x0 == t2.x0;
            if (t1.smer == 'S' && (t2.smer == 'W' || t2.smer == 'E')) return true;
            if (t1.smer == 'N' && (t2.smer == 'W' || t2.smer == 'E')) return true;
            if (t1.smer == 'W' && (t2.smer == 'N' || t2.smer == 'S')) return true;
            if (t1.smer == 'E' && (t2.smer == 'N' || t2.smer == 'S')) return true;
            return false;

        }
        static void razmeni(ref Trkac t1, ref Trkac t2)
        {
            Trkac t = new Trkac();
            t=t1;
            t1=t2;
            t1=t;
        }
        static Dogadjaj MestoSusreta(Trkac t1, Trkac t2)
        {
            Dogadjaj d = new Dogadjaj();
            double v1 = 0, v2 = 0;
            if(t1.smer=='N' && t2.smer=='S')
            {
                if(t1.x0>t2.x0) razmeni(ref t1, ref t2);
                d.t = (t2.x0 - t1.x0) / 2;
                d.x = t1.x0 + d.t;
                d.y = t1.y0;
            }
            else if (t1.smer == 'E' && t2.smer == 'W')
            {
                if (t1.y0 > t2.y0) razmeni(ref t1, ref t2);
                d.t = (t2.y0 - t1.y0) / 2;
                d.x = t1.x0;
                d.y = t1.y0 + d.t;
            }
            else if ((t1.smer == 'N' || t1.smer == 'S') && (t2.smer == 'E' || t2.smer == 'W'))
            {
                d.x = t2.x0;
                d.y = t1.y0;
                v1 = Math.Abs(d.x-t1.x0);
                v2 = Math.Abs(d.y-t2.y0);
                if (v1 == v2)
                {
                    d.t = v1;
                }
            }
            return d;

        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Tacka[] tacke = new Tacka[n];
            for (int i = 0; i < n; i++)
            {
                string s = Console.ReadLine();
                int p = s.IndexOf(" ");
                tacke[i].x = double.Parse(s.Substring(0,p));
                tacke[i].y = double.Parse(s.Substring(p+1));
            }
            Trkac[] trkaci = new Trkac[4*n];
            for (int i = 0; i < n; i++)
            {
                trkaci[4*i].smer = 'N';
                trkaci[4*i+1].smer = 'S';
                trkaci[4*i+2].smer = 'E';
                trkaci[4 * i + 3].smer = 'W';

            }
            Trkac trkac1=new Trkac();
            Trkac trkac2 = new Trkac();
            var dogadjaji = new Dictionary<Dogadjaj, int>();
            Dogadjaj d = new Dogadjaj();
            string dog="";
            for(int i = 0; i<4*n; i++)
            {
                for(int j = i+1; j<4*n; j++)
                {
                    trkac1=trkaci[i];
                    trkac2 = trkaci[j];
                    if (Susret(trkac1, trkac2))
                    {
                        d = MestoSusreta(trkac1, trkac2);
                        if (d.t >= 0 && Math.Floor(d.x) == d.x && Math.Floor(d.y) == d.y)
                        {
                            dogadjaji[d.Key]++;
                        }
                    }

                }
            }
            int uk = 0;
            int pozdrav = 0;
            foreach (var x in dogadjaji)
            {
                pozdrav = dogadjaji[x.Key];
                uk += pozdrav * (pozdrav - 1) / 2;
            }
            Console.WriteLine(uk);

        }
    }
}